/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.navigator;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.LocalConnectionPoint;
import com.aptana.ide.core.io.WorkspaceConnectionPoint;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.ui.navigator.ProjectSiteConnection;
import com.aptana.ide.syncing.ui.navigator.ProjectSitesManager;
import com.aptana.ide.ui.io.FileSystemUtils;
import com.aptana.ide.ui.io.navigator.FileSystemObject;
import com.aptana.ide.ui.io.navigator.FileTreeContentProvider;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SiteConnectionsContentProvider
extends FileTreeContentProvider {
    private static final Object[] EMPTY = new Object[0];
    private static final String[] APTANA_NATURES = new String[]{"com.aptana.projects.webnature", "com.aptana.editor.php.phpNature", "org.python.pydev.pythonNature", "org.radrails.rails.core.railsnature", "com.aptana.ruby.core.rubynature"};

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            inputElement = SyncingPlugin.getSiteConnectionManager();
        }
        return super.getElements(inputElement);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            if (project.isAccessible()) {
                boolean isAptanaProject = this.isAptanaProject(project);
                Object[] children = isAptanaProject ? new Object[]{ProjectSitesManager.getInstance().getProjectSites(project)} : new Object[]{};
                return children;
            }
        } else if (element instanceof ProjectSiteConnection) {
            IConnectionPoint connectionPoint = ((ProjectSiteConnection)((Object)element)).getSiteConnection().getDestination();
            if (connectionPoint instanceof LocalConnectionPoint) {
                try {
                    return SiteConnectionsContentProvider.fetchFileSystemChildren(((LocalConnectionPoint)connectionPoint).getRoot(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    return EMPTY;
                }
            }
            if (connectionPoint instanceof WorkspaceConnectionPoint) {
                try {
                    return ((WorkspaceConnectionPoint)connectionPoint).getResource().members();
                }
                catch (CoreException e) {
                    return EMPTY;
                }
            }
        }
        return super.getChildren(element);
    }

    private boolean isAptanaProject(IProject project) {
        Object[] natures;
        block4: {
            natures = project.getDescription().getNatureIds();
            if (!ArrayUtil.isEmpty((Object[])natures)) break block4;
            return false;
        }
        try {
            if (StringUtil.contains((String[])APTANA_NATURES, (String)natures[0])) {
                return true;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private static FileSystemObject[] fetchFileSystemChildren(IFileStore parent, IProgressMonitor monitor) throws CoreException {
        IFileInfo[] fileInfos = FileSystemUtils.childInfos((IFileStore)parent, (int)0, (IProgressMonitor)monitor);
        ArrayList<FileSystemObject> list = new ArrayList<FileSystemObject>();
        IFileInfo[] iFileInfoArray = fileInfos;
        int n = fileInfos.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo fi = iFileInfoArray[n2];
            list.add(new FileSystemObject(parent.getChild(fi.getName()), fi));
            ++n2;
        }
        return list.toArray(new FileSystemObject[list.size()]);
    }
}

